/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.fw.ntfy.TextBasedEvent;
import com.ibm.hwmca.fw.ntfy.TextField;
import com.ibm.hwmca.fw.ntfy.TextFilter;
import java.io.Serializable;
import java.util.EventObject;

public class NumericFilter
extends TextFilter
implements Serializable {
    static final long serialVersionUID = 2421284452750134469L;
    public static final int[] LEGAL_OPS = new int[]{0, 1, 4, 5, 6, 7, 9};
    private int _int;

    NumericFilter() {
    }

    public NumericFilter(String name, int operation, String operand, TextField field) {
        super(name, operation, operand, field);
    }

    public boolean validateData(int op, String operand) {
        boolean result = false;
        if (NumericFilter.isLegalOp(op, LEGAL_OPS)) {
            try {
                this._int = Integer.parseInt(operand);
                result = true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean pass(EventObject event) {
        if (!super.pass(event)) {
            return false;
        }
        boolean result = false;
        try {
            int fieldValue = Integer.parseInt(this.getFieldData(((TextBasedEvent)event).getText()));
            switch (this._operation) {
                case 0: {
                    result = fieldValue == this._int;
                    break;
                }
                case 1: {
                    result = fieldValue != this._int;
                    break;
                }
                case 4: {
                    result = fieldValue > this._int;
                    break;
                }
                case 5: {
                    result = fieldValue < this._int;
                    break;
                }
                case 6: {
                    result = fieldValue >= this._int;
                    break;
                }
                case 7: {
                    result = fieldValue <= this._int;
                    break;
                }
                case 9: {
                    result = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

